# Java开发规范



# 1. 命名规范

- class、interface、enum使用大驼峰，例如：“WxUser”
- interface命名以“I”为前缀，代表接口，例如：“IUserService” 
   - 接口实现类命名统一使用后缀impl，例如：”UserImpl“
- 包命名使用全小写
- 变量、方法、参数名等使用小驼峰，例如：“getUserInfo”
- 常量统一使用大写，不同单词间使用“_”连接，例如：“MAX_VALUE”
- JavaBean命名，统一后缀使用大写。例如：“UserInfoBO、PageVO、UserDTO”等。
- MVC各层命名示例 
   - entity——User
   - mapper/dao——UserMapper/UserDao
   - service——IUserService 
      - 实现类——UserServiceImpl
   - controller——UserController

详细见《上海信睿JavaWeb开发规范.pdf》
# 2. 开发业务规范
### 2.1. IDEA阿里巴巴代码检查插件
推荐开发前在IDEA中下载阿里巴巴代码检查插件
打开IDEA，File-> Setteings->Plugins->Browse Repositories，在Browse Repositories搜索栏搜索Alibaba，然后安装Alibaba Java Coding Guidelines
下载本地zip文件，下载地址：Alibaba Java Coding Guidelines - IntelliJ IDEs Plugin | Marketplace
下载版本 Alibaba Java Coding Guidelines 2.1.1
打开IDEA，File->Settings->Plugin->Install plugin from disk，选择刚才自己下载插件zip包的地址
### 2. 2工具类封装

- 工具类位置，推荐封装在utils下 
   - 通用工具类封装在common模块下
   - 和某个模块相关业务的工具类，封装在相关模块下
- 工具类推荐封装成static静态方法（有的不能不强求，比如需要bean注册）
### 2.3. 配置类

-  配置类位置，推荐封装在config下 
   - 通用配置类封装在common模块下
   - 和某个模块相关业务的配置类，封装在相关模块下
-  配置类使用配置方式 
   -  推荐使用Java配置类 
   -  不推荐使用xml配置（日志配置除外） 
   -  推荐配置参数写在yml中进行读取 
      - 大量的配置读取，推荐写Properties类。可以省去大量属性的@Value读取
```java
@Data
@Configuration  // 表示为配置类，注册到spring bean容器中
@ConfigurationProperties(prefix = "jwt") // 读取的yml配置的公共前缀
public class SecurityProperties {
    // 属性
}
```
### 2.4. SpringBoot

-  采用配置类使用yml文件，更好的层级结构 
-  推荐配置开发环境、测试环境、生成环境的配置文件。在不同环境下使用不同的配置文件
![image.png](https://cdn.nlark.com/yuque/0/2022/png/240791/1661784525655-fb4df49a-7783-4fc3-bc2e-6591899c21fe.png#clientId=ub895adca-d1a8-4&crop=0&crop=0&crop=1&crop=1&id=yUpCI&name=image.png&originHeight=194&originWidth=348&originalType=binary&ratio=1&rotation=0&showTitle=false&size=11247&status=done&style=none&taskId=ua5554774-75eb-401d-958f-fdd1fbd8285&title=) 
### 2.5.注释规范

-  **所有class、interface、enum等强制在类头部加注释** 
   -  注释方式：javadoc注释 
   -  注释内容 
      - 功能描述（description）
      - 作者（@author）
      - 日期（@Date）
   -  注释模板 
```java
/**
 * description:对返回前端数据进行封装
 *
 * @author sinra
 * Date: 2020/7/9 22:09
 **/
@Data
public class ResponseResult<T> {
    // ...
}
```

-  **所有成员变量，推荐添加注释** 
   -  注释方式：javadoc注释 
   -  注释模板 
```
/**
* 方式一：
* 状态码
*/
private Integer code;

/** 方式二：状态信息说明 */
private String message;
```

-  **所有方法，强制添加注释** 
   -  注释内容： 
      - 功能描述（description）
      - 参数信息（@param）
      - 返回值信息（@return）
      - 作者（@author）（推荐，可知道方法谁写的，方便维护）
      - 日期（@Date）（推荐，可知道方法大致是在什么时候写的）
   -  注释模板 
```java
/**
 * description: 接口调用成功，返回枚举中自定义的状态码及数据
 *
 * @param responseEnum 自定义枚举 状态码和信息
 * @param data         返回数据
 * @return 枚举中自定义的状态码及数据
 * @author sinra
 * Date: 2020/7/10 19:57
 */
public static <E> ResponseResult<E> ok ( ResponseEnum responseEnum, E data ) {
    return new ResponseResult<>(responseEnum, data);
}
123456789101112
```

-  **业务注释** 
   - 业务中多写注释，方便开发和维护，养成良好习惯
   - 一块业务使用块级注释
   - 一行代码使用行级注释

# 3. 日志规范
SLF4J 是门面模式的日志框架，有利于维护和各个类的日志处理方式统一，并且可以在保证不修改代码的情况下，很方便的实现底层日志框架的更换。
### 3.1 导入日志
```java
// 方式一
import org.slf4j.Logger; 
import org.slf4j.LoggerFactory;

private static final Logger log = LoggerFactory.getLogger(User.class);


// 方式二
//采用lombok的@Slf4j注解
```
### 3.2 建议使用参数占位{}
使用大括号{}来作为日志中的占位符，比于使用+操作符，更加优雅简洁。并且，**相对于反例**，使用占位符仅是替换动作，可以有效提升性能。
```java
// 正例
log.info("该用户是会员,id: {} name : {} ", id, name); 


// 反例
log.info("该用户是会员,id:  " + id + " name: " + name);
```

### 3.3 不要使用e.printStackTrace()

- e.printStackTrace()打印出的堆栈日志跟业务代码日志是交错混合在一起的，通常排查异常日志不太方便。
- e.printStackTrace()语句产生的字符串记录的是堆栈信息，如果信息太长太多，字符串常量池所在的内存空间一旦被占满，就没空间进行其它操作了，大量其它的线程就会中止，等待内存空间的释放，相互等待，等内存，锁住了，整个应用就挂掉了。
```java
// 正例
try{
  // 业务代码处理
}catch(Exception e){
  log.error("你的程序有异常啦",e);
}


// 反例
try{
  // 业务代码处理
}catch(Exception e){
  e.printStackTrace();
}
```
### 3.4 异常日志不要只打一半，要输出全部错误信息
```java
// 正例
try {
    //业务代码处理
} catch (Exception e) {
    // 错误
    log.error('你的程序有异常啦', e);
}


// 反例1，异常e都没有打印出来，所以压根不知道出了什么类型的异常。
try {
    //业务代码处理
} catch (Exception e) {
    // 错误
    log.error('你的程序有异常啦');
}


//反例2，e.getMessage()不会记录详细的堆栈异常信息，只会记录错误基本描述信息，不利于排查问题。
try {
    //业务代码处理
} catch (Exception e) {
    // 错误
    log.error('你的程序有异常啦', e.getMessage());
}
```
### 3.5 不要记录了异常，又抛出异常

- 这样实现的话，通常会把栈信息打印两次。这是因为捕获了MyException异常的地方，还会再打印一次。
- 这样的日志记录，或者包装后再抛出去，不要同时使用！否则日志看起来会很迷惑。
```java
log.error("IO exception", e);
throw new MyException(e);
```

### 3.6 核心功能模块，建议打印较完整的日志
如果核心或者逻辑复杂的代码，建议添加详细的注释，以及较详细的日志。

# 4. 第三方接口交互规范
**关键细节（附表一）**

| 关键细节 | 事项 | 备注 |
| --- | --- | --- |
| 字段内容 | 双方确定需要提供什么字段、需要获取哪些字段 | 
 |
| 接口版本 | 接口版本规范，url中 /v1/xxx，还是header中 verison=v1，以及协商版本具体规范细节 | 
 |
| 大量数据 | 分页返回 | 
 |
| 异常处理 | 定义错误码，以及其对应的相应操作，有什么兜底补偿方案没 | 
 |
| 调用方式 | 主动拉取还是被动等待推送 | 
 |
| 通信协议 | Restful、Webservice、MQ、Websocket等 | 一般建议Restful |
| 报文协议 | json、yaml、xml、自定义等 | 一般建议Json |
| 接口方式 | 同步接口还是异步接口 | 
 |
| 接口安全 | Oauth2.0 sign token等，注意内外网、以及业务的保密级别 | 
 |
| 幂等性 | 确保双方接口是否都是幂等的，防止重复提交 | 
 |
| 重试机制 | 一定要确认是否需要接口调用失败后的重试机制，保证数据传输的最终一致性
重试机制包括实时重试调用：指定次数 + 调用失败持久化，数据库定时任务重试 | 
 |
| 接口文档 | 要有详尽的说明和丰富的示例代码 | 
 |

### 4.1 提供给第三方系统的接口

- 要明确接口定义，确认对接双方甚至多方所需数据以及具体字段。
- 接口的接入参数一定要打日志记录，输出数据看情况打日志，对于变动的数据打上日志做记录。
- 日志要包含调用时间、错误原因、json数据（如果过长则记录关键字段）。
- 接口如果有大规模的资源占用要考虑对系统本身的影响，保证系统的正常运行。
- 接口的设计对于敏感数据要谨慎处理，要保证对外数据的安全性。
- 接口编写在关键代码处一定要打日志，以便监控接口运行情况以及发现错误和排除故障。
- 对外接口要形成API文档，文档包含请求方式、请求路径、入参、返回结果以及入参示例。
- 接口入参必填字段要做必填校验，防止null报错。
- 接口返回的状态码标准在文档中标明。如果是错误状态码要返回错误信息。
- 对于有幂等性要求的接口要提供查询接口，将调取的幂等性接口的结果返回。
### 4.2 调用第三方系统的接口

- 要明确调取目的、数据以及具体字段对应关系。
- 对接前尽量了解相关细节（附表一）。
- 调取第三方接口要有异常补偿机制。
- 接口调用后出现异常，记录下该方法调用的详细日志到数据库表中。
- 尝试用AOP异常捕捉的方式将补偿代码从业务代码中解耦出来处理。
- 多次调用仍然失败要记录数据以后后期人工处理。
- 补偿机制要考虑是否有幂等性，多次调用是否会对对方系统产生不同结果的影响，如果有则需要调用验证接口以验证补偿是否成功。
- 调取第三方接口字段拉平机制，可以考虑使用@JSONField注解等方式拉平2个系统之间的不同的字段值。
- 拉取数据对于一些字段值的转换，如果是固定字典关系可以建立枚举进行转换，如果经常变动的值则需要第三方给出数据接口拉取对应关系数据。
- 调用接口回调参数要有日志记录。
- 日志要包含接收时间、错误原因、json数据（如果过长则记录关键字段）。

